/** @file   AnimContainer.h
 * @brief   Declaration of AnimContainer class.
 * @version $Revision: 1.1 $
 * @date    $Date: 2006/02/21 20:44:43 $
 * @author  Tomi Lamminsaari
 */

#ifndef H_ENG2D_AnimContainer_H
#define H_ENG2D_AnimContainer_H

#include "eng2d_dll.h"
#include <vector>
#include "Animation.h"
#include "BaseContainer.h"


namespace eng2d {
  
// Forward declarations
class DataWarehouse;


/** @class  AnimContainer
 * @brief   An animation container that can contain several animations.
 * @author  Tomi Lamminsaari
 *
 * An AnimContainer is a container that can have several Animation objects. It is
 * a container object that can be placed in the DataWarehouse where you
 * can find it by its UID.
 */
class DLLIMPORT AnimContainer : public BaseContainer
{
public:

    ///
    /// Constants, datatypes and static methods
    /// =======================================


    ///
    /// Constructors, destructor and operators
    /// ======================================

    /** Default constructor.
     */
    AnimContainer();

    /** Destructor
     */
    virtual ~AnimContainer();

private:
    /** Copy constructor
     * @param   aAnother          Reference to another AnimContainer
     */
    AnimContainer( const AnimContainer& aAnother );

    /** An assignment operator
     * @param   aAnother          Reference to another AnimContainer
     * @return  Reference to this object.
     */
    AnimContainer& operator= ( const AnimContainer& aAnother );
    
public:

    ///
    /// Inherited methods
    /// =================

    /** From WarehouseItem
     */
    virtual void ResetAndDestroy();
    
    /** From WarehouseItem
     */
    virtual void Push( void* aObject );
    
    /** From WarehouseItem
     */
    virtual void* At( int aUid ) const;
    

    ///
    /// New public methods
    /// ==================
    
    /** Assings the bitmap pointers to the animations stored by this item.
     * @param   aWarehouse      Pointer to warehouse that contains the graphics.
     * @return  An errorcode.
     */
    int AssignGraphics( DataWarehouse* aWarehouse );
    

    ///
    /// Getter methods
    /// ==============

    /** Returns animation from given index.
     * @param   aUid            Index of the animation being returned.
     * @exception xOutOfBounds  Thrown if requested uid was not found.
     */
    const Animation& FindAnim( int aUid ) const throw (xOutOfBounds);
    
    /** Returns the number of animation this item stores.
     * @return  Number of animation
     */
    int AnimationCount() const;

protected:
    ///
    /// Protected interface
    /// ===================


protected:
    ///
    /// Data members
    /// ============

    std::vector<Animation*> iAnimations;
};

};

#endif
